from datetime import datetime
import json
from jose import jwt
from hashlib import md5
import requests

from dotenv import load_dotenv
import os

load_dotenv()

api_key = os.environ.get("API_KEY")

# api_key = '<<SUA API KEY>>'

def create_encoded_header(endpoint, body, method):
    client_private_key = '''-----BEGIN EC PRIVATE KEY-----
    <<SUA PRIVATE KEY>>
    -----END EC PRIVATE KEY-----'''

    today_str = datetime.utcnow().strftime("%Y-%m-%dT%H:%M:%S")

    dict_to_sign = {"timestamp": today_str, "method": method, "uri": endpoint}

    body_bytes = json.dumps(body).encode()

    md5_instance = md5()
    md5_instance.update(body_bytes)
    md5_body = md5_instance.hexdigest()


    dict_to_sign["payload_md5"] = md5_body

    jwt_headers = {"alg": "ES512", "typ": "JWT"}
    encoded_header_token = jwt.encode(
        claims=dict_to_sign,
        key=client_private_key,
        algorithm="ES512",
        headers=jwt_headers,
    )
    return encoded_header_token



base_url = "https://manager-api.sandbox.qidtvm.com.br"
endpoint = f"/security/security"
method = "POST"

body = {
    "external_id": "string",
    "asset_type": "commercial_paper",
    "b3_code":"25M000000",
    "isin_code":"BR00ABCDE000",
    "contract_number": "SCR12345",
    "ipoc_code": "string",
    "maturity_date": "YYYY-MM-DD",
    "allowed_managers": ["00.000.000/0000-00", "00.000.000/0000-00", "00.000.000/0000-00"],
    "allowed_consultants": ["00.000.000/0000-00", "00.000.000/0000-00", "00.000.000/0000-00"],
    "issuer_document_number": "00.000.000/0000-00",
    "bookkeeper_document_number": "00.000.000/0000-00",
    "number_of_units": 1,
    "principal_unit_price": 1000000.00,
    "issue_value": 1000000.00,
    "issue_unit_price": 1000000.00,
    "issue_date": "YYYY-MM-DD",
    "amortization_type": "sac",
    "installments": [
        {
            "installment_number": 1,
            "maturity_date": "YYYY-MM-DD",
            "principal_unit_price": 1000000.00,
            "face_unit_price": 1010000.00,
            "amortization_percentage": 1
        }
    ],
    "delay": {
        "fine": {
            "fine_type": "percentage",
            "percentage_value": 0.0
        },
        "interest": {
            "method": "compound",
            "pre_fixed": {
                "monthly_rate": 0.0,
                "calendar_base": "calendar_360"
            }
        }
    },
    "pre_fixed": {
        "monthly_rate": 0.01,
        "calendar_base": "calendar_360"
    },
    "post_fixed": {
        "lag": {
            "amount": 1,
            "reference": "daily"
        },
        "rate": 1,
        "indexer": "di",
        "calendar_base": "workdays"
    }
}


encoded_header_token = create_encoded_header(endpoint, body, method=method)

headers = {"API-CLIENT-KEY": api_key, "AUTHORIZATION": encoded_header_token}

url = f"{base_url}{endpoint}"

resp = requests.get(url=url, headers=headers, json=body)
print(resp.json())

